# common functions to generate uniform reports
knitr::opts_chunk$set(echo = TRUE, width = 110)

library(flextable)
library(officer)

require("modelr")
require("tidyverse")
require("tidybayes")
require("openxlsx")
require("ggstance")
require("ggridges")
require("cowplot")
require("rstan")
require("brms")
require("emmeans")

rstan_options(auto_write = TRUE)
cores <- min(4,parallel::detectCores()-1) # 4 chains will NOT sample faster >4 cores
options(mc.cores = cores)
theme_set(theme_light())
S_width <- 13.33/2.0
S_height <- 7.5/2

# add stars to p.values
signif.num <- function(x) {
  as.character(symnum(x, corr = FALSE, na = FALSE, legend = FALSE,
                      cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), 
                      symbols = c("***", "**", "*", ".", " ")))
}

# color significan emm summary in light green
emm_show <- function(myemm) {
  myft <- summary(myemm, infer=TRUE, frequentist=TRUE, adjust="mvt") %>% as_tibble
  myft <- myft %>% select(one_of(setdiff( 
    names(myft), c("emmean", "estimate", "SE", "df", "asymp.LCL", "asymp.UCL", "z.ratio")
  )))
  myft <- merge(summary(myemm), myft, sort=FALSE, all=TRUE)
  
  myft <- flextable(myft)
  myft <- bold(myft, i = ~ lower.HPD*upper.HPD > 0, bold = TRUE)
  myft <- bg(myft, i = ~ p.value >= 0.05 & lower.HPD*upper.HPD > 0, j = ~ p.value, bg="yellow")
  myft <- fontsize(myft, part = "all", size = 10)
  myft <- set_formatter(myft, p.value = function(x) sprintf("%.2e", x) )
  autofit(myft)
}
